/*---------------------------------------------------------------------------*\

    FILE....: khook.h
    TYPE....: C Function
    AUTHOR..: David Rowe
    DATE....: 1/8/02

    Kernel based hook detection module for V12PCI, links with hda.c

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2002 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __KHOOK__
#define __KHOOK__

void *khook_open(unsigned short *base2);
void khook_close(void *khook);
void khook_sample(void *khook, int btb);
int khook_read(void *khook, int ch);

// user supplied support functions, must be linked in by caller

void *khook_malloc(int size);
void khook_free(void *mem);
int khook_readw(unsigned short *addr);

#endif





